#!/bin/sh

dev1=${1:-eth0}
dev2=${2:-eth1}

t=${T:-10}

ip netns add ns_server_${dev1}
ip netns add ns_client_${dev2}

ip link set ${dev1} netns ns_server_${dev1}
ip netns exec ns_server_${dev1} ip addr add dev ${dev1} 192.168.99.1/24
ip netns exec ns_server_${dev1} ip link set dev ${dev1} up
ip link set ${dev2} netns ns_client_${dev2}
ip netns exec ns_client_${dev2} ip addr add dev ${dev2} 192.168.99.2/24
ip netns exec ns_client_${dev2} ip link set dev ${dev2} up

ip netns exec ns_server_${dev1} iperf3 -s -B 192.168.99.1&
sleep 1

ip netns exec ns_client_${dev2} iperf3 -t ${t} -c 192.168.99.1 -B 192.168.99.2

killall iperf3

ip netns exec ns_server_${dev1} ifconfig
ip netns exec ns_client_${dev2} ifconfig
ip netns del ns_server_${dev1}
ip netns del ns_client_${dev2}
