#!/bin/sh 

exit_on_error()
{
	if [ $? = 0 ]; then
		return
	fi
	text=$1
	echo "$text, exit"
	exit 1
}

mk_gpt()
{
	dev=$1
	dd if=/dev/zero of=${dev} bs=1M count=16
	sync
	parted --script  ${dev} \
		mklabel gpt \
		mkpart primary 32768s 1GiB \
		mkpart primary 2097152s 2500MiB \
		q
	parted ${dev} -s -- name 1 boot
	parted ${dev} -s -- name 2 rootfs
	parted ${dev} -s -- set 1 boot on
	sfdisk --part-uuid ${dev} 2 "614e0000-0000-4b53-8000-1d28000054a9"
	sleep 1
}

dev=$1
if [ "$dev" = "" ];then
	echo "uasge: burn_sd.sh /dev/sdX"
	exit 1
fi

fw=$(pwd)
mp=/mnt/d5

#umount
for i in 6 5 3 2 1; do
	if [ ! -e ${dev}${i} ]; then
		#no partition
		continue
	fi
	if ! grep -q ${dev}${i} /proc/mounts; then
		#not mounted
		continue
	fi
	umount ${dev}${i}
	exit_on_error "cant umount ${dev}${i}"
done

#burn
#aecho 'o n p 1 32768 +1G n p 2 2129920 +2048M a 1 w' | tr ' ' '\n' | fdisk ${dev}
#sleep 1
mk_gpt ${dev}
exit_on_error "cant write partitions table to ${dev}"

dd if=${fw}/idblock.bin of=${dev} seek=64
exit_on_error "cant write u-boot(${fw}/idblock.bin) to ${dev}"
dd if=${fw}/uboot.itb of=${dev} seek=16384
exit_on_error "cant write u-boot(${fw}/uboot.itb) to ${dev}"

mkfs.ext4 -L STORE1 -F ${dev}1
exit_on_error "cant do mkfs.ext4 on ${dev}1"
mount ${dev}1 ${mp}
exit_on_error "cant mount ${dev}1 to ${mp}"
cp -ar pboot/* ${mp}/
exit_on_error "cant copy pboot to ${mp}"
umount ${mp}
exit_on_error "cant umount ${mp}"

dd if=${fw}/rootfs.ext2 of=${dev}2 bs=1M
exit_on_error "cant write rootfs(${fw}/rootfs.ext) to ${dev}2"
e2fsck -f ${dev}2
resize2fs ${dev}2
sync
echo "Success!"
exit 0
