#!/bin/sh 

exit_on_error()
{
	if [ $? = 0 ]; then
		return
	fi
	text=$1
	echo "$text, exit"
	exit 1
}

dev=${1:-"/dev/mmcblk0"}
if [ "$dev" = "" ];then
	echo "uasge: burn_mmc.sh /dev/mmcblk0"
	exit 1
fi

#fw=/mnt/store/burn_to_emmc
script_path=$(readlink -f "$0")
fw=$(dirname "${script_path}")
mp=/tmp/mp
mkdir -p $mp

#umount
for i in 3 2 1; do
	if [ ! -e ${dev}p${i} ]; then
		#no partition
		continue
	fi
	if ! grep -q ${dev}p${i} /proc/mounts; then
		#not mounted
		continue
	fi
	umount ${dev}p${i}
	exit_on_error "cant umount ${dev}p${i}"
done

#erase u-boot envs
sudo dd if=/dev/zero of=${dev} seek=3 bs=1M count=1
#burn
echo 'o n p 1 32768 +1G n p 2 2129920 +1G n p 3 4227072 +1500M a 1 w' | tr ' ' '\n' | fdisk -u ${dev}
exit_on_error "cant write partitions table to ${dev}"
dd if=${fw}/idblock.bin of=${dev} seek=64
exit_on_error "cant write ${fw}/idblock.bin to ${dev}"
dd if=${fw}/uboot.itb of=${dev} seek=16384
exit_on_error "cant write ${fw}/uboot.itb to ${dev}"
mkfs.ext4 -F ${dev}p1
mount ${dev}p1 /opt/
cd /mnt/store/
cp -ra Image extlinux logo.bmp rk-kernel.dtb rk3568-inmys-smarc-evm.dtb rootfs.cpio.gz /opt/
umount /opt
mkfs.ext4 -F -L STORE ${dev}p3
exit_on_error "cant do mkfs.ext4 on ${dev}p3"
#mount ${dev}p3 ${mp}
#exit_on_error "cant mount ${dev}p3 to ${mp}"
#tar -xf ${fw}/add_1.tar -C ${mp}/
#exit_on_error "cant untar ${fw}/add_1.tar to ${mp}/"
#tar -xf ${fw}/add_for_burn_sd.tar -C ${mp}/
#exit_on_error "cant untar ${fw}/add_for_burn_sd.tar to ${mp}/"
sync
#umount ${mp}
exit_on_error "cant umount ${mp}"
echo "Success!"
#exit 0
read -p "Press any key to exit"

