#!/bin/sh

RED='\033[0;31m'
GREEN='\033[0;32m'
NC='\033[0m' # No Color

result=ok
exit_on_error()
{
	if [ $? = 0 ]; then
		echo -e "$2"
		return
	fi
	result=fail
	echo -e "${RED}$1${NC}"
	#exit 1
}

script_path=$(readlink -f "$0")
d=$(dirname "${script_path}")

# upper usb 2.0 is bus 1(high speed) and bus 3(full/low speed)
grep -q -e "T:  Bus=01 Lev=01" -e "T:  Bus=03 Lev=01" /sys/kernel/debug/usb/devices
exit_on_error "USB 2.0 upper connector error: no device" "USB 2.0 upper connector: OK"

# bottom usb 2.0 is bus 2(high speed) and bus 4(full/low speed)
grep -q -e "T:  Bus=02 Lev=01" -e "T:  Bus=04 Lev=01" /sys/kernel/debug/usb/devices
exit_on_error "USB 2.0 bottom connector: no device" "USB 2.0 bottom connector: OK"

# mpcie usb 2.0 is bus 7
grep -q -e "T:  Bus=07 Lev=01" /sys/kernel/debug/usb/devices
exit_on_error "MPCIE USB error: no device" "MPCIE USB: OK"

# usb 3.0 is bus 6(super speed) and bus 5(high/full/low speed)
grep -q -e "T:  Bus=05 Lev=01" -e "T:  Bus=06 Lev=01" /sys/kernel/debug/usb/devices
exit_on_error "USB 3.0 connector error: no device" "USB 3.0 connector: OK"

v=`cat /sys/class/drm/card0-eDP-1/status`
[ "${v}" = "connected" ]
exit_on_error "Display Port error: state: $v" "Display Port(eDP): OK"

v=`cat /sys/class/drm/card0-HDMI-A-1/status`
[ "${v}" = "connected" ]
exit_on_error "HDMI error: state: $v" "HDMI: OK"

# UART4 lopback test
exec 99<>/dev/ttyS4;echo tst_ttyS4_tst >&99;read -t 1 INPUT <&99
[ "${INPUT}" = "tst_ttyS4_tst" ]
exit_on_error "UART 4 loopback error, rcvd: $INPUT" "UART4(X31): OK"
exec 99>&-

# UART5 lopback test
exec 99<>/dev/ttyS5;echo tst_ttyS5_tst >&99;read -t 1 INPUT <&99
[ "${INPUT}" = "tst_ttyS5_tst" ]
exit_on_error "UART 5 loopback error, rcvd: $INPUT" "UART5(X31): OK"
exec 99>&-

# UART8 lopback test
exec 99<>/dev/ttyS8;echo tst_ttyS8_tst >&99;read -t 1 INPUT <&99
[ "${INPUT}" = "tst_ttyS8_tst" ]
exit_on_error "UART 8 loopback error, rcvd: $INPUT" "UART8(X18): OK"
exec 99>&-

# sata disk in m.2
v=`ls -l /sys/block/ | grep fc400000.sata`
[ "${v}" != "" ]
exit_on_error "M.2 SATA error" "SATA (M.2): OK"

# rtc
date -s "2022-01-25 17:19" > /dev/null
hwclock -w -u
exit_on_error "RTC i2c read error: $?" "RTC i2c read: OK"
v1=`hwclock`
sleep 1;
v2=`hwclock`
[ "$v1" != "$v2" ]
exit_on_error "RTC error: time not tick!" "RTC tick: OK"

# CAN loopback
ifconfig can0 down
ifconfig can1 down
if grep -q rockchip,canfd /proc/device-tree/can@fe590000/compatible; then
ip link set can0 up type can bitrate 1000000 dbitrate 1000000 fd on
ip link set can1 up type can bitrate 1000000 dbitrate 1000000 fd on
else
ip link set can0 up type can bitrate 1000000
ip link set can1 up type can bitrate 1000000
fi
candump -T 1000 can0 > /tmp/1.txt&
usleep 100000
cansend can1 500#1E.10.10
sleep 2
grep -q 'can0  500   \[3\]  1E 10 10' /tmp/1.txt
exit_on_error "CAN error: no loopback" "CAN: OK"

# fan
# Manual mode
fand=/sys/class/hwmon/hwmon0/device
if [ -e /sys/class/hwmon/hwmon1/device/pwm1_enable ]; then
	fand=/sys/class/hwmon/hwmon1/device
fi
echo 1 > ${fand}/pwm1_enable
echo 255 > ${fand}/pwm1  # 100%
sleep 3
v_100=`cat ${fand}/fan1_input`
[ ${v_100} -gt 2000 ]
exit_on_error "FAN error set 100% (readed ${v_100})" "FAN 100%: OK"
sleep 2
echo 25 > ${fand}/pwm1  # 10%
v_10=`cat ${fand}/fan1_input`
[ ${v_100} -gt 300 ]
exit_on_error "FAN error set 25% (readed ${v_10})" "FAN 25%: OK"

# imx219 camera
gst-launch-1.0 v4l2src device=/dev/video1 num-buffers=10 ! fakesink >/dev/null
exit_on_error "Camera: error: $?" "Camera: OK"

# emmc
[ -e /dev/mmcblk0 ]
exit_on_error "no EMMC device" "EMMC detect: OK"
fdisk -l /dev/mmcblk0 > /dev/null
exit_on_error "EMMC error" "EMMC read: OK"

# check pcie3x2
v=`lspci -n | grep -e 197b:0585 | wc -l`
[ "${v}" = "1" ]
exit_on_error "PCIE3 error ($v visible)" "PCIE3: OK"

# test loopback eth0<->eth1
#${d}/test_loop.sh eth0 eth1
# test one eth (eth0 or eth1)
ping -w 3 -c 1 ya.ru >/dev/null
exit_on_error "Ethernet error" "Ethernet: OK"

[ "$result" = "ok" ]
exit_on_error "FAIL!" "${GREEN}SUCCESS${NC}"

read -p "Press any key to exit"

